/*
created by Chris Ruff on 4/11/14.
//  Copyright (c) 2014 Chris Ruff. All rights reserved.

This program uses the PIR sensor to detect motion. 
Run the program by ./main.c "port which main sever is running on"
*/

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <ifaddrs.h>
#include <errno.h>
#include<sys/mman.h>
#include<fcntl.h>

//timeval used to capture time for different parts of the program.
struct timeval real_time;
struct timeval car_arrive;
struct timeval car_arrive2;
struct timeval real_ticket_time;


#define MSG_SIZE 40			// message size for socket
#define PARKING_METER_ID 1 // this is the id of the parking meter
#define DayilyLim  60 // how long a car can stay at the location before another ticket
#define InputLim  10 // how long a car can stay at location with out paying




void error(const char *msg)
{
    perror(msg);
    exit(0);
}

typedef struct parking_struct
{
    int money_in; // how much money was added to add time to real time
    int end_program;  // how to know to end program
    int time_flag; // flag to know if time was addded
    long real_time; // amount of time on paid for
    int ticket_flag;  // 0 for no ticket 1 if ticket should be given
    int car_at_meter; // 0 no car 1 a car a meeter
    int sock;
    unsigned int length;
    int boolval;
    int error_message;
    char buffer[MSG_SIZE];
    char message_to_server[5]; // will hold the message to send to server every few seconds

    // NEW FOR TCP
    int sockfd, portno;// n;
    struct sockaddr_in serv_addr;
    struct hostent *server;
    char *ip_server; // ip of server must be known before running clients

}parking_struct;


void ticket_pipe (parking_struct *parking)
{ //  this thread will send info to sever every few seconds.
 // create message to send to server

    char random_buffer[3];

    // Message that will come in on buffer will be in this format - all ints.
    // Parking Meter Number, car at metter =1 no car = 0; if should ticket =1  else =0;

    // picture will be at the end in what ever format it needs to be
    //char* buff = "3 1 1"; example of what ever wants


    //printf("%s\n", parking->message_to_server);

    while (1)
    {
    	 snprintf(random_buffer, sizeof(random_buffer), "%d ", PARKING_METER_ID);
    	 strcpy(parking->message_to_server, random_buffer);

        if ( parking->ticket_flag == 1)
        {
            //printf("Write to sever that parking meter 1 has a car and needs a ticket\n");

           // write to server message should be 1 1 1
            // this is meter 1 with a car that needs a ticket
            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->car_at_meter);
            strcat(parking->message_to_server, random_buffer);

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->ticket_flag);
            strcat(parking->message_to_server, random_buffer);

            parking->ticket_flag = 0;

        }
        else if(parking->car_at_meter ==1)
        {
            //printf("Write to sever that parking meter 1 has a car and needs no ticket\n");

            // write to server message should be 1 1 0
            // this is meter 1 with a car that needs a ticket

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->car_at_meter);
            strcat(parking->message_to_server, random_buffer);

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->ticket_flag);
            strcat(parking->message_to_server, random_buffer);

        }
        else
        {
            //printf("Write to sever that parking meter 1 has no car and needs no ticket\n");

            // write to server message should be 1 0 0
            // this is meter 1 with a car that needs a ticket

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->car_at_meter);
            strcat(parking->message_to_server, random_buffer);

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->ticket_flag);
            strcat(parking->message_to_server, random_buffer);

        }

      //printf("%s\n",parking->message_to_server);

      bzero(parking->buffer,MSG_SIZE);			// sets all values to zero. memset() could be used

      parking->error_message = write(parking->sockfd,parking->message_to_server,strlen(parking->message_to_server));
      if (parking->error_message < 0)
         error("ERROR writing to socket");

      sleep(2);

    }// end of while (1) loop

}
void pir (parking_struct *parking)
{
	   //parking->car_at_meter = 1;
	   
// sets up the PIR sensor. maps the registes on the TS-7250 board.

	unsigned int *PBDR, *PBDDR;
	int car =0;

	unsigned char         *start;
	int                   fd = open( "/dev/mem", O_RDWR|O_SYNC );

	start   = (unsigned char *)mmap(0, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x80840000);
	PBDR    = (unsigned int *)(start + 0x04);     // port b
	PBDDR   = (unsigned int *)(start + 0x14);     // port b direction register
	*PBDDR  = 0xFF;	 // all inputs
	*PBDR   = 0x00;


    while (1) 
    {
    	// printf(" %d  %d\n" ,  *PBDR, *PBDDR );
    	if( ( *PBDR & 0X01) == 1)
		{
    		if ( car == 0) // check to see if a car was already there or not
    		{
    			printf("Motion Car arriving\n");
    		    car =1;
    		    parking->car_at_meter = 1;
    		    sleep(6); // delay to ensure to other detecting is made
    		    gettimeofday(&car_arrive, NULL); // get the time when the car arrived.
    		            // with this time I will check to ensure they paid with in a time and if they stay longer then 6 hours
    		 }
    		 else
    		 {
    			 printf("Motion Car leaving\n");
				 car =0;
    		     parking->car_at_meter = 0;
    		     sleep(6); // allow time for the PIR to start again

    		 }
    	}//end( *PBDR & 0X01) == 1)
    	else
    	{
    		 ///printf("No motion\n");
    		 gettimeofday(&car_arrive2, NULL);
    		if ( (car_arrive.tv_sec + InputLim) == car_arrive2.tv_sec)
    		{
    			printf("car should be ticketd for not paying in time\n");
    			parking->ticket_flag = 1;
    		}

    		if ( (car_arrive.tv_sec + DayilyLim) == car_arrive2.tv_sec)
    		{
    			printf("car should be ticketd for being parked for to long\n");
    			parking->ticket_flag = 1;
    		}

    		sleep(1);
    	}

    }

    pthread_exit(0);
}

void ticket_time (parking_struct *parking)
{
    while (1)
    {
    	gettimeofday(&real_ticket_time, NULL);
        if(parking->car_at_meter == 0)
        {
            parking->real_time = 0;
        }
        if ( parking->real_time == real_ticket_time.tv_sec)
        {

          //  printf( "Ticket needs to be given\n" );
            fflush(stdout);
            parking->ticket_flag = 1;
            parking->real_time = 0;

        }

    }//end of while

    pthread_exit(0);
}

void money (parking_struct *parking)
{// this thread checks for money input once the car has arrived.

    fflush(stdout);

    parking->money_in = 2;

    while (parking->money_in != 0)
    {
    	fflush(stdout);
        while ( (parking->money_in > 1 || parking->money_in < 3) && parking->car_at_meter == 1)
        {
        	fflush(stdout);
            printf("Input money for time\n");
            printf(" 1: 5 sec,  2: 10 sec, 3: 25 sec\n");
            scanf("%d", &parking->money_in);

            if ( parking->money_in ==1) // 5 sec
            {
                //system("clear");
                if(parking->real_time == 0)
                {

                gettimeofday(&real_time, NULL);
                parking->real_time = real_time.tv_sec;
               // printf("time = %lu\n", real_time.tv_sec);
                }

                parking->time_flag = 1; // set flag to know time was added to clock

                parking->real_time += 5;
               // printf("time = %lu \n", parking->real_time);
            }

            else if (parking->money_in == 2) // 10 sec
            {
                if(parking->real_time == 0)
                {

                    gettimeofday(&real_time, NULL);
                    parking->real_time = real_time.tv_sec;
                    //printf("time = %lu\n", real_time.tv_sec);
                }
                parking->time_flag = 1; // set flag to know time was added to clock

                parking->real_time += 10;
                //printf("time = %lu \n", parking->real_time);

            }

            else if (parking->money_in == 3) //25
            {
                if(parking->real_time == 0)
                {

                    gettimeofday(&real_time, NULL);
                    parking->real_time = real_time.tv_sec;
                    //printf("time = %lu\n", real_time.tv_sec);
                }

                parking->time_flag = 1; // set flag to know time was added to clock

                parking->real_time += 25;
                //printf("time = %lu \n", parking->real_time);

            }
            else if (parking->money_in == 0 )
            {

                printf("closing\n");
            }

            else
            {

                printf("wrong input\n");
            }

        }//end of while

    }// end of while

    pthread_exit(0);
}

int main(int argc, const char * argv[])
{//sets up socket communication for main server and threads to run.

    if (argc < 2) // add back in to have server port
    {
      printf("usage: %s Port which server is on \n", argv[0]);
      exit(0);
     }

    parking_struct *parking = NULL;
    parking = malloc(sizeof(parking_struct));

    if ( parking == NULL )
    {
        printf("Malloc problem with parking mem");
        return 0;
    }

    parking->money_in = 1;
    parking->real_time = 0;
    parking->ticket_flag =  0;
    parking->car_at_meter = 0;
    parking->boolval = 1;
    parking-> ip_server = "10.3.52.17"; // ip of server must be known before running clients


    char hostn[400]; //placeholder for the hostname
    struct hostent *hostIP; //placeholder for the IP address

    //if the gethostname returns a name then the program will get the ip address using gethostbyname
    //if needed to know ip address of the location this program is running on
    if((gethostname(hostn, sizeof(hostn))) == 0)
    {
        hostIP = gethostbyname(hostn); //the netdb.h function gethostbyname
        //printf("IP address: %s\n", inet_ntoa(*(struct in_addr*)hostIP->h_addr));
    }
    else
    {
        printf("ERROR:FC4539 - IP Address not found."); //error if thehostname is not found
    }

    parking->portno = atoi(argv[1]);		// port # was an input.
    parking->sockfd = socket(AF_INET, SOCK_STREAM, 0); // Creates socket. Connection based.
    if (parking->sockfd < 0)
       error("ERROR opening socket");

    parking->server = gethostbyname(parking->ip_server);  // converts hostname input (e.g. 10.3.52.255)
    if (parking->server == NULL)
    {
    	fprintf(stderr,"ERROR, no such host\n");
        exit(0);
    }

        // fill in fields of serv_addr
    bzero((char *) &parking->serv_addr, sizeof(parking->serv_addr));	// sets all values to zero
    parking->serv_addr.sin_family = AF_INET;		// symbol constant for Internet domain
    bcopy((char *)parking->server->h_addr, (char *)&parking->serv_addr.sin_addr.s_addr, parking->server->h_length);

    parking->serv_addr.sin_port = htons(parking->portno);		// fill sin_port field

    // establish connection to the server
    if (connect(parking->sockfd,(struct sockaddr *) &parking->serv_addr,sizeof(parking->serv_addr)) < 0)
    	error("ERROR connecting");


    pthread_t money_input, time , pir_hardware, pipe_ticket;


    //pthread_create(&thread name, NULL, (void*)&pthread fucntion, (void*)what to send);

    pthread_create(&money_input, NULL, (void*)&money, (void*)parking);  // get money from user
    pthread_create(&time, NULL, (void*)&ticket_time, (void*)parking);   // check real time vs amount of time bought.
    pthread_create(&pir_hardware, NULL, (void*)&pir, (void*)parking);   // checks pir hardware if car is parked or not
    pthread_create(&pipe_ticket, NULL, (void*)&ticket_pipe, (void*)parking);    // send info on pipe for a ticket


    //while (parking->money_in != 0)
    while (1)
    {
    }//end of while loop

    free(parking);


    return 0;
}

